<!-- index.php -->
<?php 
include ('includes/header.php');

$table_name = 'themes';
$page_name = 'themes';
$data = ['themeid' => '0'];

$db->insertIfEmpty($table_name, $data);

$res = $db->select($table_name, '*', '', '');

if(isset($_POST['submit'])){
    unset($_POST['submit']);
    $updateData = $_POST;
    $db->update($table_name, $updateData, 'id = :id',[':id' => 1]);
    echo "<script>window.location.href='". $page_name.".php'</script>";
}


?>
<!-- Form Start -->
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <h2 class="mb-4">Color Themes</h6>
                    <form method="post">
                        <select class="form-select mb-3" id="themeid" name="themeid">
                            <option value="0" <?=$res[0]['themeid']=='0'?'selected':'' ?>>Default Theme</option>
							<option value="1" <?=$res[0]['themeid']=='1'?'selected':'' ?>>Theme 1</option>
							<option value="2" <?=$res[0]['themeid']=='2'?'selected':'' ?>>Theme 2</option>
							<option value="3" <?=$res[0]['themeid']=='3'?'selected':'' ?>>Theme 3</option>
							<option value="4" <?=$res[0]['themeid']=='4'?'selected':'' ?>>Theme 4</option>
							<option value="5" <?=$res[0]['themeid']=='5'?'selected':'' ?>>Theme 5</option>
							<option value="6" <?=$res[0]['themeid']=='6'?'selected':'' ?>>Theme 6</option>
							<option value="7" <?=$res[0]['themeid']=='7'?'selected':'' ?>>Theme 7</option>
							<option value="8" <?=$res[0]['themeid']=='8'?'selected':'' ?>>Theme 8</option>
                        </select>
                        <button type="submit" name="submit" class="btn btn-primary">Update Themes settings</button>
                    </form>
            </div>
        </div>
    </div>
</div>


<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <div class="grid-container">
        <div class="grid-item">
            <img src="./img/theme/theme_0.png" alt="Image 1">
            <div class="image-text">Default Theme</div>
        </div>
        <div class="grid-item">
            <img src="./img/theme/theme_1.png" alt="Image 2">
            <div class="image-text">Theme 1</div>
        </div>
        <div class="grid-item">
            <img src="./img/theme/theme_2.png" alt="Image 3">
            <div class="image-text">Theme 2</div>
        </div>
        <div class="grid-item">
            <img src="./img/theme/theme_3.png" alt="Image 1">
            <div class="image-text">Theme 3</div>
        </div>
        <div class="grid-item">
            <img src="./img/theme/theme_4.png" alt="Image 2">
            <div class="image-text">Theme 4</div>
        </div>
        <div class="grid-item">
            <img src="./img/theme/theme_5.png" alt="Image 3">
            <div class="image-text">Theme 5</div>
        </div>
        <div class="grid-item">
            <img src="./img/theme/theme_6.png" alt="Image 1">
            <div class="image-text">Theme 6</div>
        </div>
        <div class="grid-item">
            <img src="./img/theme/theme_7.png" alt="Image 2">
            <div class="image-text">Theme 7</div>
        </div>   
        <div class="grid-item">
            <img src="./img/theme/theme_8.png" alt="Image 3">
            <div class="image-text">Theme 8</div>
        </div> 
         
            </div>
        </div>
    </div>
</div>
<!-- Form End -->
<style>
    .grid-container {
        display: grid;
        grid-template-columns: repeat(3, 1fr); /* Default for PC and large screens */
        gap: 10px;
        padding: 10px;
    }

    .grid-item {
        text-align: center;
    }

    .grid-item img {
        max-width: 100%;
        height: auto;
    }

    .image-text {
        margin-top: 5px;
        font-size: 16px;
        color: #fff;
    }

    /* 🔻 Mobile View: Screens 768px and below */
    @media (max-width: 768px) {
        .grid-container {
            grid-template-columns: repeat(1, 1fr);
        }
        .image-text {
            margin-top: 3px;
            font-size: 10px;
            color: #fff;
        }
    }
</style>

<!-- Footer Start -->
<?php include ('includes/footer.php');?>
<!-- Footer End -->
</body>

</html>